package com.jumeirah.api.app.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jumeirah.common.entity.SysNoticeRead;
import com.jumeirah.common.param.SysNoticeReadQueryVo;
import com.jumeirah.common.service.SysNoticeReadService;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 系统通知已读 未读 控制器
 *
 * @author xxx
 * @since 2020-11-06
 */
@Slf4j
@RestController
@RequestMapping("/app/sysNoticeRead")
@Api(value = "系统通知已读 未读API", tags = {"系统通知已读 未读"})
public class SysNoticeReadController extends BaseController {

    @Autowired
    private SysNoticeReadService sysNoticeReadService;

    /**
     * 获取系统通知已读 未读详情
     */
    @GetMapping("/getNoticeReadByUser")
    @OperationLog(name = "用户是否已读系统通知", type = OperationLogType.INFO)
    @ApiOperation(value = "用户是否已读系统通知")
    public ApiResult<SysNoticeReadQueryVo> getSysNoticeReadByUser() throws Exception {
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();

        SysNoticeRead one = sysNoticeReadService.getOne(
                new QueryWrapper<SysNoticeRead>().lambda().eq(SysNoticeRead::getUserId, jwtToken.getUserId()));
        SysNoticeReadQueryVo sysNoticeReadQueryVo = new SysNoticeReadQueryVo();

        if (null == one) {
            SysNoticeRead sysNoticeRead = new SysNoticeRead();
            sysNoticeRead.setUserId(jwtToken.getUserId());
            sysNoticeRead.setReadStatus(0);
            sysNoticeReadService.save(sysNoticeRead);
            sysNoticeReadQueryVo.setRead(0);

        } else {
            sysNoticeReadQueryVo.setRead(one.getReadStatus());
        }

        return ApiResult.ok(sysNoticeReadQueryVo);
    }


//    /**
//     * 添加系统通知已读 未读
//     */
//    @PostMapping("/add")
//        @OperationLog(name = "添加系统通知已读 未读", type = OperationLogType.ADD)
//    @ApiOperation(value = "添加系统通知已读 未读")
//    public ApiResult<Boolean> addSysNoticeRead(@Validated(Add.class) @RequestBody SysNoticeRead sysNoticeRead)throws Exception{
//            boolean flag= sysNoticeReadService.saveSysNoticeRead(sysNoticeRead);
//            return ApiResult.result(flag);
//            }
//
//    /**
//     * 修改系统通知已读 未读
//     */
//    @PostMapping("/update")
//        @OperationLog(name = "修改系统通知已读 未读", type = OperationLogType.UPDATE)
//    @ApiOperation(value = "修改系统通知已读 未读")
//    public ApiResult<Boolean> updateSysNoticeRead(@Validated(Update.class) @RequestBody SysNoticeRead sysNoticeRead)throws Exception{
//            boolean flag= sysNoticeReadService.updateSysNoticeRead(sysNoticeRead);
//            return ApiResult.result(flag);
//            }
//
//    /**
//     * 删除系统通知已读 未读
//     */
//    @PostMapping("/delete/{id}")
//        @OperationLog(name = "删除系统通知已读 未读", type = OperationLogType.DELETE)
//    @ApiOperation(value = "删除系统通知已读 未读")
//    public ApiResult<Boolean> deleteSysNoticeRead(@PathVariable("id") Long id)throws Exception{
//            boolean flag= sysNoticeReadService.deleteSysNoticeRead(id);
//            return ApiResult.result(flag);
//            }
//
//    /**
//     * 获取系统通知已读 未读详情
//     */
//    @GetMapping("/info/{id}")
//        @OperationLog(name = "系统通知已读 未读详情", type = OperationLogType.INFO)
//    @ApiOperation(value = "系统通知已读 未读详情")
//    public ApiResult<SysNoticeReadQueryVo> getSysNoticeRead(@PathVariable("id") Long id)throws Exception{
//            SysNoticeReadQueryVo sysNoticeReadQueryVo = sysNoticeReadService.getSysNoticeReadById(id);
//            return ApiResult.ok(sysNoticeReadQueryVo);
//            }


//    /**
//     * 系统通知已读 未读分页列表
//     */
//    @PostMapping("/getPageList")
//        @OperationLog(name = "系统通知已读 未读分页列表", type = OperationLogType.PAGE)
//    @ApiOperation(value = "系统通知已读 未读分页列表")
//    public ApiResult<Paging<SysNoticeReadQueryVo>>getSysNoticeReadPageList(@Validated @RequestBody SysNoticeReadPageParam sysNoticeReadPageParam)throws Exception{
//            Paging<SysNoticeReadQueryVo> paging = sysNoticeReadService.getSysNoticeReadPageList(sysNoticeReadPageParam);
//            return ApiResult.ok(paging);
//            }

}

