package com.jumeirah.common.entity;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import com.baomidou.mybatisplus.annotation.IdType;
import java.util.Date;
import com.baomidou.mybatisplus.annotation.Version;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

import io.geekidea.springbootplus.framework.core.validator.groups.Update;

/**
 * 商家权限
 *
 * @author wei
 * @since 2020-09-28
 */
@Data
@Accessors(chain = true)
    @EqualsAndHashCode(callSuper = true)
@ApiModel(value = "MerchantPermission对象")
public class MerchantPermission extends BaseEntity {
private static final long serialVersionUID=1L;

            @NotNull(message = "id不能为空", groups = {Update.class})
        @ApiModelProperty("主键")
                @TableId(value = "id", type = IdType.AUTO)
                private Long id;

            @ApiModelProperty("权限名称")
        private String name;

            @ApiModelProperty("父id")
        private Long parentId;

            @ApiModelProperty("路径")
        private String url;

            @NotBlank(message = "唯一编码不能为空")
        @ApiModelProperty("唯一编码")
        private String code;

            @ApiModelProperty("图标")
        private String icon;

            @NotNull(message = "类型，1：菜单，2：按钮不能为空")
        @ApiModelProperty("类型，1：菜单，2：按钮")
        private Integer type;

            @NotNull(message = "层级，1：第一级，2：第二级，N：第N级不能为空")
        @ApiModelProperty("层级，1：第一级，2：第二级，N：第N级")
        private Integer level;

            @ApiModelProperty("状态，0：禁用，1：启用")
        private Integer state;

            @ApiModelProperty("排序")
        private Integer sort;

            @ApiModelProperty("备注")
        private String remark;

            @ApiModelProperty("版本")
        @Version
    private Integer version;

            @ApiModelProperty("创建时间")
        private Date createTime;

            @ApiModelProperty("修改时间")
        private Date updateTime;

}
