package com.jumeirah.api.app.controller;

import com.jumeirah.common.param.MerchantPageParam;
import com.jumeirah.common.service.MerchantService;
import com.jumeirah.common.vo.MerchantQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 航空介绍 控制器
 *
 * @author wei
 * @since 2020-09-29
 */
@Slf4j
@RestController
@RequestMapping("/app/airline")
@Api(value = "航空介绍", tags = {"航空公司介绍"})
public class AirIntroducedController extends BaseController {

    @Autowired
    private MerchantService merchantService;

    /**
     * 商家分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "航空公司介绍分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "航空公司介绍分页列表")
    public ApiResult<Paging<MerchantQueryVo>> getMerchantPageList(@Validated @RequestBody MerchantPageParam merchantPageParam) throws Exception {
        Paging<MerchantQueryVo> paging = merchantService.getMerchantPageList(merchantPageParam);
        return ApiResult.ok(paging);
    }
}

