package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.jumeirah.common.entity.MerchantUser;
import com.jumeirah.common.param.MerchantUserPageParam;
import com.jumeirah.common.vo.MerchantUserQueryVo;

import org.springframework.stereotype.Repository;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.io.Serializable;

/**
 * 商家 Mapper 接口
 *
 * @author wei
 * @since 2020-09-28
 */
@Repository
public interface MerchantUserMapper extends BaseMapper<MerchantUser> {

            /**
             * 根据ID获取查询对象
             *
             * @param id
             * @return
             */
        MerchantUserQueryVo getMerchantUserById(Serializable id);

            /**
             * 获取分页对象
             *
             * @param page
             * @param merchantUserPageParam
             * @return
             */
            IPage<MerchantUserQueryVo> getMerchantUserPageList(@Param("page") Page page,@Param("param") MerchantUserPageParam merchantUserPageParam);

        }
