
package com.jumeirah.common.enums;

import io.geekidea.springbootplus.framework.common.enums.BaseEnum;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 付款状态，0-未付款，1-付款中，2-已付款，3-退款中，99-已退款
 **/
@Getter
@AllArgsConstructor
public enum StatePaymentStatusEnum implements BaseEnum {

//    0-UNPAID, 1-PAYING, 2-PAID, 3-REFUNDING, 99-REFUNDED

    /**
     * 未付款
     **/
    UNPAID(0, "未付款"),
    /**
     * 付款中
     **/
    PAYING(1, "付款中"),
    /**
     * 已付款
     **/
    PAID(2, "已付款"),
    /**
     * 退款中
     **/
    REFUNDING(3, "退款中"),
    /**
     * 已退款
     **/
    REFUNDED(99, "已退款");

    private final Integer code;
    private final String desc;

}
