package com.jumeirah.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.SysNotice;
import com.jumeirah.common.mapper.SysNoticeMapper;
import com.jumeirah.common.param.SysNoticePageParam;
import com.jumeirah.common.param.SysNoticeQueryVo;
import com.jumeirah.common.service.SysNoticeService;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 系统通知表 服务实现类
 *
 * @author xxx
 * @since 2020-11-06
 */
@Slf4j
@Service
public class SysNoticeServiceImpl extends BaseServiceImpl<SysNoticeMapper, SysNotice> implements SysNoticeService {

    @Autowired
    private SysNoticeMapper sysNoticeMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveSysNotice(SysNotice sysNotice) throws Exception {
        return super.save(sysNotice);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateSysNotice(SysNotice sysNotice) throws Exception {
        return super.updateById(sysNotice);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteSysNotice(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public SysNoticeQueryVo getSysNoticeById(Long id) throws Exception {
        return sysNoticeMapper.getSysNoticeById(id);
    }

    @Override
    public Paging<SysNoticeQueryVo> getSysNoticePageList(SysNoticePageParam sysNoticePageParam) throws Exception {
        Page<SysNoticeQueryVo> page = new PageInfo<>(sysNoticePageParam, OrderItem.desc(getLambdaColumn(SysNotice::getCreateTime)));
        IPage<SysNoticeQueryVo> iPage = sysNoticeMapper.getSysNoticePageList(page, sysNoticePageParam);
        return new Paging<SysNoticeQueryVo>(iPage);
    }

}
