package com.jumeirah.api.app.entity.vo;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 行程表
 *
 * @author wei
 * @since 2020-09-29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "添加货运行程入参对象")
public class StrokeAddFreightVo extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "出发城市id不能为空")
    @ApiModelProperty("出发城市id")
    private Long cityOutsetId;

    @NotBlank(message = "出发城市名称不能为空")
    @ApiModelProperty("出发城市名称")
    private String cityOutsetName;

    @NotNull(message = "到达城市id不能为空")
    @ApiModelProperty("到达城市id")
    private Long cityArriveId;

    @NotBlank(message = "到达城市名称不能为空")
    @ApiModelProperty("到达城市名称")
    private String cityArriveName;

    @NotNull(message = "出发时间不能为空")
    @ApiModelProperty("出发时间")
    private Long outsetTime;

    @NotBlank(message = "货物名称不能为空")
    @ApiModelProperty("货物名称")
    private String goodsName;

    @NotBlank(message = "货物体积不能为空")
    @ApiModelProperty("货物体积（长*宽*高） 单位：CM，例如：100*102*120")
    private String goodsSize;

    @NotNull(message = "货物重量不能为空")
    @ApiModelProperty("货物重量，单位：吨")
    private Double goodsWeight;

}
