package com.jumeirah.common.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jumeirah.common.entity.MerchantUserPermission;
import com.jumeirah.common.param.MerchantUserPermissionPageParam;
import com.jumeirah.common.param.MerchantUserPermissionQueryVo;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.io.Serializable;
import java.util.Set;

/**
 * 商家用户权限关系 Mapper 接口
 *
 * @author giao
 * @since 2020-10-19
 */
@Repository
public interface MerchantUserPermissionMapper extends BaseMapper<MerchantUserPermission> {

    /**
     * 根据角色id获取可用的权限编码
     *
     * @param userId
     * @return
     */
    Set<String> getPermissionCodesByUserId(@Param("userId") Long userId);

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     */
    MerchantUserPermissionQueryVo getMerchantUserPermissionById(Serializable id);

    /**
     * 获取分页对象
     *
     * @param page
     * @param merchantUserPermissionPageParam
     * @return
     */
    IPage<MerchantUserPermissionQueryVo> getMerchantUserPermissionPageList(@Param("page") Page page, @Param("param") MerchantUserPermissionPageParam merchantUserPermissionPageParam);

}
