package com.sien.common.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.sien.common.entity.VipRecord;
import com.sien.common.mapper.VipRecordMapper;
import com.sien.common.param.VipRecordOpenParam;
import com.sien.common.param.VipRecordPageParam;
import com.sien.common.service.VipRecordService;
import com.sien.common.vo.VipRecordQueryVo;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.PageInfo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Calendar;

/**
 * Vip开通记录 服务实现类
 *
 * @author hewei
 * @since 2021-02-25
 */
@Slf4j
@Service
public class VipRecordServiceImpl extends BaseServiceImpl<VipRecordMapper, VipRecord> implements VipRecordService {

    @Autowired
    private VipRecordMapper vipRecordMapper;

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean saveVipRecord(VipRecord vipRecord) throws Exception {
        return super.save(vipRecord);
    }

    @Override
    public boolean openVip(VipRecordOpenParam vipRecordOpenParam) throws Exception {
        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();

        VipRecord vipRecord = new VipRecord();
        vipRecord.setFkUserId(jwtToken.getUserId());
        vipRecord.setMoney(vipRecordOpenParam.getMoney());
        vipRecord.setFkRechargeUser(-1L);

        // 设置到期时间
        Calendar calendar = Calendar.getInstance();
        calendar.add(Calendar.YEAR, vipRecordOpenParam.getYears());
        vipRecord.setExpiredAt(calendar.getTime());
        vipRecord.setYears(vipRecordOpenParam.getYears());
        vipRecord.setVipLevel(vipRecordOpenParam.getVipLevel());
//        vipRecord.setRemark("");
//        vipRecord.setCreateTime(new Date());
//        vipRecord.setUpdateTime(new Date());

        // 判断是否为替他人
        if (vipRecordOpenParam.getIsAgent()) {
            vipRecord.setFkRechargeUser(vipRecordOpenParam.getAgentUserId());
        }

        return super.save(vipRecord);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean updateVipRecord(VipRecord vipRecord) throws Exception {
        return super.updateById(vipRecord);
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public boolean deleteVipRecord(Long id) throws Exception {
        return super.removeById(id);
    }

    @Override
    public VipRecordQueryVo getVipRecordById(Long id) throws Exception {
        return vipRecordMapper.getVipRecordById(id);
    }

    @Override
    public Paging<VipRecordQueryVo> getVipRecordPageList(VipRecordPageParam vipRecordPageParam) throws Exception {
        Page<VipRecordQueryVo> page = new PageInfo<>(vipRecordPageParam, OrderItem.desc(getLambdaColumn(VipRecord::getCreateTime)));
        IPage<VipRecordQueryVo> iPage = vipRecordMapper.getVipRecordPageList(page, vipRecordPageParam);
        return new Paging<VipRecordQueryVo>(iPage);
    }

}
