package com.ym.im.util;

import org.springframework.context.MessageSource;

import java.util.Locale;

/**
 * @author 陈俊雄
 * @date 2019/6/3
 **/
public class MessageUtils {

    public static MessageSource messageSource;

    public static void setMessageSource(MessageSource ms) {
        messageSource = ms;
    }

    public MessageSource getMessageSource() {
        return messageSource;
    }

    public static String getMsg(String code, Object[] args, Locale locale) {
        return messageSource.getMessage(code, args, locale);
    }

    public static String getMsg(String code, Locale locale, Object... args) {
        return messageSource.getMessage(code, args, locale);
    }

    public static String getMsg(String code, Object[] args, String locale) {
        return messageSource.getMessage(code, args, new Locale(locale));
    }

    public static String getMsg(String code, Object[] args) {
        return messageSource.getMessage(code, args, Locale.getDefault());
    }

    public static String getMsg(String code, Locale locale) {
        return messageSource.getMessage(code, null, locale);
    }

    public static String getMsg(String code, String locale) {
        return messageSource.getMessage(code, null, new Locale(locale));
    }

    public static String getMsg(String code) {
        return messageSource.getMessage(code, null, Locale.getDefault());
    }
}
