package com.ym.im.entity;

import io.netty.util.AttributeKey;

import java.util.HashMap;
import java.util.Map;

/**
 * @author: JJww
 * @Date:2019-05-17
 */
public class NettyConstant {


    /**
     * ID
     */
    public static final AttributeKey<Long> ID = AttributeKey.valueOf("id");


    /**
     * 用户(0) or 客服(1)
     */
    public static final AttributeKey<Integer> TYPE = AttributeKey.valueOf("type");


    /**
     * 客服ID
     */
    public static final AttributeKey<Long> STAFF_ID = AttributeKey.valueOf("staff");

    /**
     * 当前token
     */
    public static final AttributeKey<String> TOKEN_INFO = AttributeKey.valueOf("token");

    /**
     * 客户端当前语言
     */
    public static final AttributeKey<String> COL_INFO = AttributeKey.valueOf("col");

    /**
     * 连接类型：用户
     */
    public static final int CONNECT_TYPE_USER = 0;

    /**
     * 连接类型：客服
     */
    public static final int CONNECT_TYPE_STAFF = 1;

    /**
     * ws标识
     */
    public static final String WS = "/ws";

    /**
     * 用户 ws标识
     */
    public static final String USER_WS = "app";

    /**
     * 客服 ws标识
     */
    public static final String STAFF_WS = "web";

    /**
     * Token
     */
    public static final String TOKEN = "token";

    /**
     * 当前语言
     */
    public static final String COL = "col";

    /**
     * 最大线程量
     */
    public static final Integer MAX_THREADS = 1024;

    /**
     * 数据包最大长度
     */
    public static final Integer MAX_FRAME_LENGTH = 65535;

    /**
     * redis 聊天记录KEY
     */
    public static final String MSG_KEY = "MSG: ";

    /**
     * 客服socket 绑定的用户列表
     */
    public static final String STAFF_USERIDS_KEY = "staff.userIds: ";

    /**
     * 用户socket 相关信息
     */
    public static final String IM_USERS = "im.users";


    /**
     * 重发次数
     */
    public static final Integer RETRY_COUNT = 3;

    public static final Map<String, Integer> CONNECT_TYPE = new HashMap<String, Integer>() {
        {
            put("app", 0);
            put("web", 1);
        }
    };
}


