package com.ym.im.config;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;


/**
 * @author JJww
 */
@Configuration
public class NettyConfig {

    public static final String ROOM = "/room";

    public static final Integer MAX_THREADS = 1024;

    public static final Integer MAX_FRAME_LENGTH = 65535;

    public static final AttributeKey<Long> USER_ID = AttributeKey.valueOf("userId");



    /**
     * 负责TCP连接建立操作 绝对不能阻塞
     *
     * @return
     */
    @Bean(name = "bossGroup")
    public NioEventLoopGroup bossGroup() {
        return new NioEventLoopGroup();
    }

    /**
     * 负责Socket读写操作 绝对不能阻塞
     *
     * @return
     */
    @Bean(name = "workerGroup")
    public NioEventLoopGroup workerGroup() {
        return new NioEventLoopGroup();
    }

    /**
     * Handler中出现IO操作(如数据库操作，网络操作)使用这个
     *
     * @return
     */
    @Bean(name = "businessGroup")
    public EventExecutorGroup businessGroup() {
        return new DefaultEventExecutorGroup(16);
    }
}
