package com.jumeirah.common.enums;

/**
 * 行程类型，0-单程，1-往返行程，2-货运，3-医疗
 */
public enum StrokeTypeEnum {

    ONE_WAY(0, "单程"),
    ROUND_TRIP(1, "往返"),
    CARGO_FLIGHT(2, "货运"),
    MEDICAL_FLIGHT(3, "医疗");

    /**
     * 编号
     */
    private final Integer id;
    /**
     * 名称
     */
    private final String name;

    StrokeTypeEnum(Integer id, String name) {

        this.id = id;
        this.name = name;

    }
}
