package com.jumeirah.common.service;

import com.jumeirah.common.entity.Stroke;
import com.jumeirah.common.param.McStrokePageParam;
import com.jumeirah.common.param.McStrokePaymentPageParam;
import com.jumeirah.common.param.StrokePageParam;
import com.jumeirah.common.vo.McStrokePaymentQueryVo;
import com.jumeirah.common.vo.McStrokeQueryVo;
import com.jumeirah.common.vo.StrokeDetailVo;
import com.jumeirah.common.vo.StrokeQueryVo;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 行程表 服务类
 *
 * @author wei
 * @since 2020-09-29
 */
public interface StrokeService extends BaseService<Stroke> {

    /**
     * 保存
     *
     * @param stroke
     * @return
     * @throws Exception
     */
    boolean saveStroke(Stroke stroke) throws Exception;

    /**
     * 修改
     *
     * @param stroke
     * @return
     * @throws Exception
     */
    boolean updateStroke(Stroke stroke) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteStroke(Long id) throws Exception;


    boolean cancelStroke(Long id) throws Exception;


    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    StrokeDetailVo getStrokeById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param strokePageParam
     * @return
     * @throws Exception
     */
    Paging<StrokeQueryVo> getStrokePageList(StrokePageParam strokePageParam) throws Exception;

    /**
     * 商家端，分页获取行程接口
     * @param mcStrokePageParam
     * @return
     */
    Paging<McStrokeQueryVo> getMcStrokePageList(McStrokePageParam mcStrokePageParam);

    /**
     *  收款记录
     * @param mcStrokePaymentPageParam
     * @return
     */
    Paging<McStrokePaymentQueryVo> getPaymentPageList(McStrokePaymentPageParam mcStrokePaymentPageParam);
}
