package io.geekidea.springbootplus.system.service.impl;

import cn.hutool.core.util.RandomUtil;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.system.entity.SysUser;
import io.geekidea.springbootplus.system.param.LoginParam;
import io.geekidea.springbootplus.system.param.RegisterParam;
import io.geekidea.springbootplus.system.service.LoginService;
import io.geekidea.springbootplus.system.service.RegisterService;
import io.geekidea.springbootplus.system.service.SysUserService;
import io.geekidea.springbootplus.system.vo.LoginSysUserTokenVo;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletResponse;

@Api
@Slf4j
@Service
public class RegisterServiceImpl implements RegisterService {

    @Autowired
    private LoginService loginService;

    @Autowired
    private SysUserService sysUserService;

    @Override
    public ApiResult<LoginSysUserTokenVo> register(RegisterParam registerParam, HttpServletResponse response, String language) throws Exception {

        SysUser sysUser = new SysUser();
        sysUser.setUsername(registerParam.getPhone());
        sysUser.setPhone(registerParam.getPhone());
        sysUser.setNickname(RandomUtil.randomString(8));
        sysUser.setPassword(registerParam.getPassword());
        sysUser.setState(1);
        // h5 用户
        sysUser.setRoleId(24L);
        sysUser.setDepartmentId(205L);

        // 存库
        boolean saveSysUser = sysUserService.saveSysUser(sysUser);

        // 登陆
        LoginParam loginParam = new LoginParam();

        loginParam.setUsername(registerParam.getPhone());
        loginParam.setPassword(registerParam.getPassword());
        return loginService.login(loginParam, response, language);
    }
}
