package com.jumeirah.common.service.impl;

import com.jumeirah.common.entity.SysNoticeRead;
import com.jumeirah.common.mapper.SysNoticeReadMapper;
import com.jumeirah.common.param.SysNoticeReadPageParam;
import com.jumeirah.common.param.SysNoticeReadQueryVo;
import com.jumeirah.common.service.SysNoticeReadService;
import io.geekidea.springbootplus.framework.common.service.impl.BaseServiceImpl;
import io.geekidea.springbootplus.framework.core.pagination.Paging;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 系统通知已读 未读 服务实现类
 *
 * @author xxx
 * @since 2020-11-06
 */
@Slf4j
@Service
public class SysNoticeReadServiceImpl extends BaseServiceImpl<SysNoticeReadMapper, SysNoticeRead> implements SysNoticeReadService {

@Autowired
private SysNoticeReadMapper sysNoticeReadMapper;

@Transactional(rollbackFor = Exception.class)
@Override
public boolean saveSysNoticeRead(SysNoticeRead sysNoticeRead)throws Exception{
        return super.save(sysNoticeRead);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean updateSysNoticeRead(SysNoticeRead sysNoticeRead)throws Exception{
        return super.updateById(sysNoticeRead);
        }

@Transactional(rollbackFor = Exception.class)
@Override
public boolean deleteSysNoticeRead(Long id)throws Exception{
        return super.removeById(id);
        }

    @Override
    public SysNoticeReadQueryVo getSysNoticeReadById(Long id)throws Exception{
            return sysNoticeReadMapper.getSysNoticeReadById(id);
            }

@Override
public Paging<SysNoticeReadQueryVo> getSysNoticeReadPageList(SysNoticeReadPageParam sysNoticeReadPageParam)throws Exception{
//        Page<SysNoticeReadQueryVo> page=new PageInfo<>(sysNoticeReadPageParam,OrderItem.desc(getLambdaColumn(SysNoticeRead::getCreateTime)));
//            IPage<SysNoticeReadQueryVo> iPage= sysNoticeReadMapper.getSysNoticeReadPageList(page, sysNoticeReadPageParam);
//        return new Paging<SysNoticeReadQueryVo>(iPage);
    return null;
        }

        }
