package com.jumeirah.common.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;
import java.sql.Timestamp;

/**
 * 包机介绍
 *
 * @author giao
 * @since 2020-10-14
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "CharterIntroduction对象")
public class CharterIntroduction extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "主键ID不能为空")
    @ApiModelProperty("主键ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @NotNull(message = "商家ID不能为空")
    @ApiModelProperty("商家ID")
    private Long mcId;

    @NotNull(message = "状态，0-正常，1-取消，99-删除不能为空")
    @ApiModelProperty("状态，0-正常，1-取消，99-删除")
    private Integer status;

    @ApiModelProperty("创建时间")
    private Timestamp createTime;

    @ApiModelProperty("更新时间")
    private Timestamp updateTime;

    @ApiModelProperty("包机图片url")
    private String imgUrl;

    @ApiModelProperty("包机文字")
    private String text;

    @ApiModelProperty("包机标题")
    private String title;

    @ApiModelProperty("类型 1私人;2团体;3货运;4医疗")
    private Integer type;

}
