package com.jumeirah.common.vo;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.jumeirah.common.entity.base.ImgJson;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.List;

/**
 * <pre>
 * 行程表 查询结果对象
 * </pre>
 *
 * @author wei
 * @date 2020-09-29
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "StrokeDetailVo对象")
@TableName(autoResultMap = true)
public class StrokeDetailVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空", groups = {Update.class})
    @ApiModelProperty("主键ID")
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    @NotNull(message = "出发城市id不能为空")
    @ApiModelProperty("出发城市id")
    private Long cityOutsetId;

    @ApiModelProperty("逻辑删除，0：未删除，1：已删除")
    @TableLogic
    private Integer deleted;

    @NotBlank(message = "出发城市名称不能为空")
    @ApiModelProperty("出发城市名称")
    private String cityOutsetName;

    @NotNull(message = "到达城市id不能为空")
    @ApiModelProperty("到达城市id")
    private Long cityArriveId;

    @NotBlank(message = "到达城市名称不能为空")
    @ApiModelProperty("到达城市名称")
    private String cityArriveName;

    @NotNull(message = "人数不能为空")
    @ApiModelProperty("人数")
    private Integer peopleNum;

    @NotNull(message = "飞机型号ID不能为空")
    @ApiModelProperty("飞机型号ID")
    private Long plainTypeId;

    @NotNull(message = "出发时间不能为空")
    @ApiModelProperty("出发时间")
    private Timestamp outsetTime;

    @ApiModelProperty("返程时间")
    private Timestamp returnTime;

    @NotNull(message = "行程类型，0-单程，1-往返行程，2-货运，3-医疗不能为空")
    @ApiModelProperty("行程类型，0-单程，1-往返行程，2-货运，3-医疗")
    private Integer type;

    @NotNull(message = "状态，0-审核中，1-进行中，2-已完成，99-取消不能为空")
    @ApiModelProperty("状态，0-审核中，1-进行中，2-已完成，99-取消")
    private Integer status;

    @NotNull(message = "创建时间不能为空")
    @ApiModelProperty("创建时间")
    private Timestamp createTime;

    @ApiModelProperty("更新时间")
    private Timestamp updateTime;

    @ApiModelProperty("货物名称")
    private String goodsName;

    @ApiModelProperty("货物体积（长*宽*高） 单位：CM，例如：100*102*120")
    private String goodsSize;

    @ApiModelProperty("货物重量，单位：吨")
    private Double goodsWeight;

    @ApiModelProperty("病人疾病名称")
    private String diseaseName;

    @TableField(typeHandler = FastjsonTypeHandler.class)
    @ApiModelProperty("病人病情诊断书")
    private List<ImgJson> medicalCertificateUrl;

    @ApiModelProperty("配备器械（格式：1,2,3）逗号分隔")
    private String instruments;

    @ApiModelProperty("医护人员，0-医生，1-护士，2-护工（格式：0,1,2）逗号分隔")
    private String medicalPersons;

    @ApiModelProperty("备注")
    private String remarks;

    @ApiModelProperty("价格")
    private BigDecimal money;

    @NotNull(message = "用户ID不能为空")
    @ApiModelProperty("用户ID")
    private Long userId;

    @NotNull(message = "商家id不能为空")
    @ApiModelProperty("商家id")
    private Long mcId;

    @NotNull(message = "用户选择机型不能为空")
    @ApiModelProperty("用户选择机型")
    private Long choosePlainType;


    @NotBlank(message = "出发机场名称不能为空")
    @ApiModelProperty("出发机场名称")
    private String outsetAirportName;

    @NotBlank(message = "到达机场名称不能为空")
    @ApiModelProperty("到达机场名称")
    private String arriveAirportName;

    @NotNull(message = "返程飞机型号ID为空")
    @ApiModelProperty("返程飞机型号ID")
    private Long arrivePlainTypeId;

    @NotBlank(message = "返程出发机场名称不能为空")
    @ApiModelProperty("返程出发机场名称")
    private String backOutsetAirportName;

    @NotBlank(message = "返程到达机场名称不能为空")
    @ApiModelProperty("返程到达机场名称")
    private String backArriveAirportName;

    @ApiModelProperty("商家名称")
    private String merchantName;

    @NotNull(message = "付款状态不能为空")
    @ApiModelProperty("付款状态，0-未付款，1-付款中，2-已付款，3-退款中，99-已退款")
    private Integer paymentStatus;

    @NotNull(message = "审核状态不能为空")
    @ApiModelProperty("审核状态,0审核中,1审核通过,2审核未通过")
    private Integer auditStatus;

}
