package com.ym.im.service;

import com.ym.im.entity.ChatRecord;
import com.ym.im.entity.MsgBody;
import com.ym.im.entity.PullChatRecord;
import com.ym.im.validation.group.ChatRecordSaveGroup;
import org.springframework.validation.annotation.Validated;

import javax.validation.Valid;
import java.util.List;

/**
 * <p>
 * 聊天记录 服务类
 * </p>
 *
 * @author 陈俊雄
 * @since 2019-05-28
 */
@Validated
public interface ChatRecordService {
    /**
     * 聊天记录表数量
     */
    int NUMBER_OF_TABLE = 16;

    @Validated({ChatRecordSaveGroup.class})
    int insert(ChatRecord chatRecord);

    @Validated({ChatRecordSaveGroup.class})
    int insertSelective(@Valid ChatRecord chatRecord);

    int updateByRecordId(ChatRecord chatRecord);

    int updateByIdSelective(ChatRecord chatRecord);

    int updateReceiveTime(ChatRecord chatRecord);

    ChatRecord selectById(Long id, Long userId);

    MsgBody<PullChatRecord> getChatRecord(PullChatRecord pull);

    MsgBody<List<ChatRecord>> updateReceiveTime(List<ChatRecord> chats);

    ChatRecord getLatestMsg(Long userId, Long merchantId);

}
