package com.jumeirah.common.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.baomidou.mybatisplus.extension.handlers.FastjsonTypeHandler;
import com.jumeirah.common.entity.base.ImgJson;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

/**
 * <pre>
 * 公务机出售/托管表 查询结果对象
 * </pre>
 *
 * @author giao
 * @date 2020-10-14
 */
@Data
@Accessors(chain = true)
@ApiModel(value = "BusinessPlainQueryForAppVo对象")
@TableName(autoResultMap = true)
public class BusinessPlainQueryForAppVo implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("商家name")
    private String mcName;

    @ApiModelProperty("机型介绍")
    private String introduction;

    @ApiModelProperty("销售员姓名")
    private String name;

    @ApiModelProperty("销售联系电话")
    private String phone;

    @ApiModelProperty("微信号")
    private String wechat;

    @ApiModelProperty("商家头像")
    private String mcHead;

    @ApiModelProperty("推荐:  0不推荐  1推荐")
    private Integer recommend;

    @TableField(typeHandler = FastjsonTypeHandler.class)
    @ApiModelProperty("图片相关数据json (包括：路径，宽和高)")
    private List<ImgJson> imgList;
}
