package com.jumeirah.api.merchant.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jumeirah.common.entity.CharterIntroduction;
import com.jumeirah.common.param.CharterIntroductionAddParam;
import com.jumeirah.common.param.CharterIntroductionUpdateParam;
import com.jumeirah.common.service.CharterIntroductionService;
import com.jumeirah.common.vo.CharterIntroductionQueryVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.core.validator.groups.Add;
import io.geekidea.springbootplus.framework.core.validator.groups.Update;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 包机介绍 控制器
 *
 * @author giao
 * @since 2020-10-14
 */
@Slf4j
@RestController
@RequestMapping("/merchant/charterIntroduction")
@Api(value = "包机介绍API", tags = {"包机介绍"})
public class CharterIntroductionForMerController extends BaseController {

    @Autowired
    private CharterIntroductionService charterIntroductionService;

    /**
     * 添加包机介绍
     */
    @PostMapping("/add")
    @OperationLog(name = "添加包机介绍", type = OperationLogType.ADD)
    @ApiOperation(value = "添加包机介绍")
    @RequiresPermissions("merchant:aircraft:management:edit")
    public ApiResult<Boolean> addCharterIntroduction(@Validated(Add.class) @RequestBody CharterIntroductionAddParam charterIntroductionAddParam) throws Exception {
        boolean flag = charterIntroductionService.saveCharterIntroduction(charterIntroductionAddParam);
        return ApiResult.result(flag);
    }

    /**
     * 修改包机介绍
     */
    @PostMapping("/update")
//    @OperationLog(name = "修改包机介绍", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改包机介绍")
    @RequiresPermissions("merchant:aircraft:management:edit")
    public ApiResult<Boolean> updateCharterIntroduction(@Validated(Update.class) @RequestBody CharterIntroductionUpdateParam charterIntroductionUpdateParam) throws Exception {
        boolean flag = charterIntroductionService.updateCharterIntroduction(charterIntroductionUpdateParam);
        return ApiResult.result(flag);
    }

    /**
     * 删除包机介绍
     */
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除包机介绍", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除包机介绍")
    @RequiresPermissions("merchant:aircraft:management:edit")
    public ApiResult<Boolean> deleteCharterIntroduction(@PathVariable("id") Long id) throws Exception {
        boolean flag = charterIntroductionService.deleteCharterIntroduction(id);
        return ApiResult.result(flag);
    }

    /**
     * 获取包机介绍详情
     */
    @GetMapping("/info/{id}")
    @OperationLog(name = "包机介绍详情", type = OperationLogType.INFO)
    @ApiOperation(value = "包机介绍详情")
    @RequiresPermissions("merchant:aircraft:management:view")
    public ApiResult<CharterIntroductionQueryVo> getCharterIntroduction(@PathVariable("id") Long id) throws Exception {
        CharterIntroductionQueryVo charterIntroductionQueryVo = charterIntroductionService.getCharterIntroductionById(id);
        return ApiResult.ok(charterIntroductionQueryVo);
    }

    /**
     * 包机介绍分页列表
     */
    @PostMapping("/getPageList")
    @OperationLog(name = "包机介绍分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "包机介绍分页列表")
    @RequiresPermissions("merchant:aircraft:management:view")
    public ApiResult<List<CharterIntroduction>> getCharterIntroductionPageList() throws Exception {

        JwtToken jwtToken = (JwtToken) SecurityUtils.getSubject().getPrincipal();
        List<CharterIntroduction> list = charterIntroductionService.list(
                new QueryWrapper<CharterIntroduction>().lambda().eq(CharterIntroduction::getMcId, jwtToken.getMcId()));
        return ApiResult.ok(list);
    }


}

