package com.jumeirah.api.app.controller;

import com.jumeirah.api.app.service.AppUserApiService;
import com.jumeirah.common.param.app.AppSmsRegisterParam;
import com.jumeirah.common.param.app.AppUserInfoParam;
import com.jumeirah.common.param.app.AppUserPhoneUpdateParam;
import com.jumeirah.common.param.app.DeviceTokenParam;
import com.jumeirah.common.service.AppUserService;
import com.jumeirah.common.vo.app.LoginAppUserTokenVo;
import io.geekidea.springbootplus.framework.common.api.ApiResult;
import io.geekidea.springbootplus.framework.common.controller.BaseController;
import io.geekidea.springbootplus.framework.log.annotation.Module;
import io.geekidea.springbootplus.framework.log.annotation.OperationLog;
import io.geekidea.springbootplus.framework.log.enums.OperationLogType;
import io.geekidea.springbootplus.framework.shiro.jwt.JwtToken;
import io.geekidea.springbootplus.framework.shiro.util.JwtTokenUtil;
import io.geekidea.springbootplus.framework.shiro.util.JwtUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

/**
 * APP用户 控制器
 *
 * @author wei
 * @since 2020-09-23
 */
@Slf4j
@RestController
@Module("api-app")
@Api(value = "用户API", tags = {"APP用户相关"})
@RequestMapping("/app/user/")
public class AppUserController extends BaseController {

    @Autowired
    private AppUserService appUserService;

    @Autowired
    private AppUserApiService appUserApiService;

    /**
     * ios-添加或修改推送token
     */
    @PostMapping("/iosDeviceToken")
    @OperationLog(name = "ios-添加或修改推送token", type = OperationLogType.ADD)
    @ApiOperation(value = "ios-添加或修改推送token", notes = "添加和修改都调用此接口", response = ApiResult.class)
    public ApiResult<Boolean> addIosAppDeviceToken(@RequestBody DeviceTokenParam deviceTokenParam) throws Exception {

        boolean flag = appUserService.updateDeviceToken(deviceTokenParam, 2);
        return ApiResult.result(flag);
    }

    /**
     * android-添加或修改推送token
     */
    @PostMapping("/androidDeviceToken")
    @OperationLog(name = "android-添加或修改推送token", type = OperationLogType.ADD)
    @ApiOperation(value = "android-添加或修改推送token", notes = "添加和修改都调用此接口", response = ApiResult.class)
    public ApiResult<Boolean> addAppDeviceToken(@RequestBody DeviceTokenParam deviceTokenParam) throws Exception {

        boolean flag = appUserService.updateDeviceToken(deviceTokenParam, 1);
        return ApiResult.result(flag);
    }


    /**
     * 补充或修改APP用户信息
     */
    @PostMapping("/updateAppUserInfo")
    @OperationLog(name = "补充或修改APP用户信息", type = OperationLogType.ADD)
    @ApiOperation(value = "补充或修改APP用户信息", notes = "不需要修改的字段传入null或直接不传入该字段,如果传入空双引号的话会将数据置为空 ", response = ApiResult.class)
    public ApiResult<Boolean> updateAppUserInfo(@RequestBody AppUserInfoParam appUserInfoParam) throws Exception {
        boolean flag = appUserApiService.updateAppUser(appUserInfoParam);
        return ApiResult.result(flag);
    }

    /**
     * 修改手机号
     */
    @PostMapping("/updatePhone")
    @OperationLog(name = "修改手机号", type = OperationLogType.ADD)
    @ApiOperation(value = "修改手机号", response = ApiResult.class)
    public ApiResult<Boolean> updatePhone(@RequestBody AppUserPhoneUpdateParam userPhoneUpdateParam) throws Exception {

        return appUserApiService.updatePhone(userPhoneUpdateParam.getPhoneArea(), userPhoneUpdateParam.getPhone(), userPhoneUpdateParam.getCode());
    }

    /* *//**
     * 添加APP用户
     *//*
    @PostMapping("/add")
    @OperationLog(name = "添加APP用户", type = OperationLogType.ADD)
    @ApiOperation(value = "添加APP用户", response = ApiResult.class)
    @RequiresRoles("sys:admin")
    public ApiResult<Boolean> addAppUser(@Validated(Add.class) @RequestBody AppUser appUser) throws Exception {
        boolean flag = appUserService.saveAppUser(appUser);
        return ApiResult.result(flag);
    }

    *//**
     * 修改APP用户
     *//*
    @PostMapping("/update")
    @OperationLog(name = "修改APP用户", type = OperationLogType.UPDATE)
    @ApiOperation(value = "修改APP用户", response = ApiResult.class)
    @RequiresRoles("sys:admin")
    public ApiResult<Boolean> updateAppUser(@Validated(Update.class) @RequestBody AppUser appUser) throws Exception {
        boolean flag = appUserService.updateAppUser(appUser);
        return ApiResult.result(flag);
    }

    *//**
     * 删除APP用户
     *//*
    @PostMapping("/delete/{id}")
    @OperationLog(name = "删除APP用户", type = OperationLogType.DELETE)
    @ApiOperation(value = "删除APP用户", response = ApiResult.class)
    @RequiresRoles("sys:admin")
    public ApiResult<Boolean> deleteAppUser(@PathVariable("id") Long id) throws Exception {
        boolean flag = appUserService.deleteAppUser(id);
        return ApiResult.result(flag);
    }

    *//**
     * 获取APP用户详情
     *//*
    @GetMapping("/info/{id}")
    @OperationLog(name = "APP用户详情", type = OperationLogType.INFO)
    @ApiOperation(value = "APP用户详情", response = AppUserQueryVo.class)
    @RequiresRoles("sys:admin")
    public ApiResult<AppUserQueryVo> getAppUser(@PathVariable("id") Long id) throws Exception {
        AppUserQueryVo appUserQueryVo = appUserService.getAppUserById(id);
        return ApiResult.ok(appUserQueryVo);
    }

    */

    /**
     * APP用户分页列表
     *//*
    @PostMapping("/getPageList")
    @OperationLog(name = "APP用户分页列表", type = OperationLogType.PAGE)
    @ApiOperation(value = "APP用户分页列表", response = AppUserQueryVo.class)
    @RequiresRoles("sys:admin")
    public ApiResult<Paging<AppUserQueryVo>> getAppUserPageList(@Validated @RequestBody AppUserPageParam appUserPageParam) throws Exception {
        Paging<AppUserQueryVo> paging = appUserService.getAppUserPageList(appUserPageParam);
        return ApiResult.ok(paging);
    }*/
    @PostMapping("/registerOrLogin")
    @ApiOperation(value = "手机号注册+登陆", notes = "app用户注册+登陆", response = LoginAppUserTokenVo.class)
    public ApiResult<LoginAppUserTokenVo> registerOrLogin(@Validated @RequestBody AppSmsRegisterParam appSmsRegisterParam, @RequestHeader(required = false) String language) throws Exception {
        return appUserApiService.register(appSmsRegisterParam, language);
    }

    @GetMapping("/userInfo")
    @ApiOperation(value = "根据token获取userInfo", notes = "客服模块调用")
    public AppUser getUserInfo() {
        return appUserApiService.getUserInfo(Long.valueOf(JwtUtil.getUsername(JwtTokenUtil.getToken())));
    }

}

