package com.jumeirah.common.service;

import com.jumeirah.common.entity.StrokeDiscount;
import com.jumeirah.common.param.StrokeDiscountPageParam;
import io.geekidea.springbootplus.framework.common.service.BaseService;
import com.jumeirah.common.vo.StrokeDiscountQueryVo;
import io.geekidea.springbootplus.framework.core.pagination.Paging;

/**
 * 优惠行程表 服务类
 *
 * @author xxx
 * @since 2020-10-14
 */
public interface StrokeDiscountService extends BaseService<StrokeDiscount> {

    /**
     * 保存
     *
     * @param strokeDiscount
     * @return
     * @throws Exception
     */
    boolean saveStrokeDiscount(StrokeDiscount strokeDiscount) throws Exception;

    /**
     * 修改
     *
     * @param strokeDiscount
     * @return
     * @throws Exception
     */
    boolean updateStrokeDiscount(StrokeDiscount strokeDiscount) throws Exception;

    /**
     * 删除
     *
     * @param id
     * @return
     * @throws Exception
     */
    boolean deleteStrokeDiscount(Long id) throws Exception;

    /**
     * 根据ID获取查询对象
     *
     * @param id
     * @return
     * @throws Exception
     */
    StrokeDiscountQueryVo getStrokeDiscountById(Long id) throws Exception;

    /**
     * 获取分页对象
     *
     * @param strokeDiscountPageParam
     * @return
     * @throws Exception
     */
    Paging<StrokeDiscountQueryVo> getStrokeDiscountPageList(StrokeDiscountPageParam strokeDiscountPageParam) throws Exception;

}
