package com.jumeirah.api.merchant.entity.param;

import io.geekidea.springbootplus.framework.common.entity.BaseEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotNull;

/**
 * 行程表
 *
 * @author wei
 * @since 2020-09-29
 */
@Data
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "Stroke确认付款对象")
public class StrokeConfirmPaymentParam extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @NotNull(message = "id不能为空")
    @ApiModelProperty("主键ID")
    private Long id;

    @NotNull(message = "付款状态不能为空")
    @ApiModelProperty("付款状态，0-未付款，1-付款中，2-已付款，3-退款中，99-已退款")
    private Integer paymentStatus;

}
