package com.ym.im.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Positive;
import java.io.Serializable;
import java.util.List;

/**
 * @author 陈俊雄
 * @date 2019/5/28
 **/
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PullChatRecord implements Serializable {

    @NotNull(message = "{error.user_id_empty}")
    @Positive(message = "{error.user_id_greater_than_zero}")
    @ApiModelProperty(value = "用户Id")
    private Long userId;

    @NotNull(message = "{error.merchant_id_empty}")
    @Positive(message = "{error.merchant_id_greater_than_zero}")
    @ApiModelProperty(value = "商户Id")
    private Long merchantId;

    @Positive(message = "{error.chat_id_greater_than_zero}")
    @ApiModelProperty(value = "聊天记录Id，为获取坐标")
    private Long chatRecordId;

    @Pattern(regexp = "(?i)forward|backward", message = "{error.chat_id_direction}")
    @ApiModelProperty(value = " 聊天记录Id，为获取坐标\n" +
            "     * 小于当前聊天记录Id：往前（forward）\n" +
            "     * 大于当前聊天记录Id：往后（backward）")
    private String direction;

    @Positive(message = "{error.chat_page_num}")
    @ApiModelProperty(value = "分页页数")
    private Integer pageNum = 1;

    @Positive(message = "{error.chat_page_size}")
    @ApiModelProperty(value = "分页大小")
    private Integer pageSize = 20;

    @ApiModelProperty(value = "总条数")
    private Long total;

    @ApiModelProperty(value = "总页数")
    private Integer pages;

    @NotEmpty(message = "{error.chat_order_by_empty}")
    @ApiModelProperty(value = "聊天记录Id，为获取坐标的查询结果根据某字段做排序")
    private String orderBy = "id";

    @Pattern(regexp = "(?i)asc|desc", message = "{error.chat_sorting}")
    @ApiModelProperty(value = "升序：asc 降序：desc")
    private String sorting = "desc";

    @ApiModelProperty(value = "查询结果")
    private List<ChatRecord> chatRecords;
}