package com.yumeng.libcommon.utils

import android.graphics.Bitmap
import java.io.ByteArrayOutputStream

object ByteUtils {

    /**
     * bitmap to Array
     */
    fun bmpToByteArray(bmp: Bitmap, needRecycle: Boolean): ByteArray {
        val output = ByteArrayOutputStream()
        bmp.compress(Bitmap.CompressFormat.PNG, 100, output)
        if (needRecycle) {
            bmp.recycle()
        }

        val result = output.toByteArray()
        try {
            output.close()
        } catch (e: Exception) {
            e.printStackTrace()
        }

        return result
    }
}