package org.jeecg.pm.entity.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author: JJww
 * @Date:2022/4/6
 */
@Getter
@AllArgsConstructor
public enum EventLevel {

    /**
     * 普通事件
     */
    ORDINARY(0, "普通事件"),

    /**
     * 低级报警
     */
    LOW_LEVEL(1, "低级报警"),

    /**
     * 中级报警
     */
    INTERMEDIATE(2, "中级报警"),

    /**
     * 高级报警
     */
    SENIOR(3, "高级报警"),


    UNKNOWN(9, "未知类型");

    /**
     * 状态码
     */
    private final Integer level;

    /**
     * 状态说明
     */
    private final String remark;

}
