package org.jeecg.pm.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecg.common.aspect.annotation.Dict;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: pm_access_control_device
 * @Author: jeecg-boot
 * @Date: 2022-03-15
 * @Version: V1.0
 */
@Data
@TableName(value = "pm_access_control_device", autoResultMap = true)
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "pm_access_control_device对象", description = "pm_access_control_device")
public class PmAccessControlDevice implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
    private Long id;
    /**
     * 区域名称
     */
    @Excel(name = "区域名称", width = 15)
    @ApiModelProperty(value = "区域名称")
    private String districtName;
    /**
     * 设备编码
     */
    @Excel(name = "设备编码", width = 15)
    @ApiModelProperty(value = "设备编码")
    private String code;
    /**
     * 设备类型
     */
    @ApiModelProperty(value = "设备类型 1:出入口闸机 2:访客一体机 3:自助访客机 4:身份证读卡器 5:人脸识别")
    @Excel(name = "设备类型", width = 15,dicCode = "alarm_query_equipmentType")
    @Dict(dicCode = "alarm_query_equipmentType")
    private Integer type;
    /**
     * 设备名称
     */
    @Excel(name = "设备名称", width = 15)
    @ApiModelProperty(value = "设备名称")
    private String name;
    /**
     * 设备ip
     */
    @Excel(name = "设备ip", width = 15)
    @ApiModelProperty(value = "设备ip")
    private String ip;
    /**
     * 设备位置
     */
    @Excel(name = "设备位置", width = 15)
    @ApiModelProperty(value = "设备位置")
    private String place;
    /**
     * xy值
     */
    @ApiModelProperty(value = "xy值")
    @Excel(name = "xy值", width = 15)
    @TableField(typeHandler = Coordinate.TypeHandler.class)
    private Coordinate coordinate;
    /**
     * 开门时间
     */
    @ApiModelProperty(value = "开门时间")
    @Excel(name = "开门时间（秒）", width = 15)
    private Integer doorOpenTime;
    /**
     * 生产日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "生产日期")
    private Date dateOfProduction;
    /**
     * 安装日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "安装日期")
    private Date installationDate;
    /**
     * 保修截止日期
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "保修截止日期")
    private Date warrantyPeriod;
    /**
     * 生产厂商
     */
    @ApiModelProperty(value = "生产厂商")
    private String manufacturer;
    /**
     * 状态
     */
//    @Excel(name = "状态", width = 15,dicCode = "access_control_status")
    @Dict(dicCode = "access_control_status")
    @ApiModelProperty(value = "状态 1:正常 2:离线 3:维修")
    private Integer status;
    /**
     * 创建人Id（sys_user）
     */
    @ApiModelProperty(value = "创建人Id（sys_user）")
    @Dict(dictTable = "sys_user", dicText = "realname", dicCode = "id")
    private String createUserId;
    /**
     * 修改人Id（sys_user）
     */
    @ApiModelProperty(value = "修改人Id（sys_user）")
    @Dict(dictTable = "sys_user", dicText = "realname", dicCode = "id")
    private String modifyUserId;
    /**
     * 创建时间
     */
    @Excel(name = "创建时间", width = 15, format = "yyyy-MM-dd hh:mm:ss")
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd hh:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
    /**
     * 修改时间
     */
    @JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd hh:mm:ss")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;
    /**
     * 删除状态
     */
    @ApiModelProperty(value = "删除状态")
    private Boolean deleted;
}
