package org.jeecg.pm.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.jeecg.common.aspect.annotation.Dict;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: 广告屏信息发布
 * @Author: jeecg-boot
 * @Date:   2022-05-18
 * @Version: V1.0
 */
@Data
@TableName("advertising_screen_announce")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="advertising_screen_announce对象", description="广告屏信息发布")
public class AdvertisingScreenAnnounceVo implements Serializable {
    private static final long serialVersionUID = 1L;

	/**id*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
    private Long id;
	/**广告屏设置id*/
	@Excel(name = "广告屏设置id", width = 15)
    @ApiModelProperty(value = "广告屏设置id")
    private String settingId;
	/**信息类型*/
    /**设备编码*/
    @Excel(name = "设备编码", width = 15)
    @ApiModelProperty(value = "设备编码")
    private String code;
    /**设备名称*/
    @Excel(name = "设备名称", width = 15)
    @ApiModelProperty(value = "设备名称")
    private String name;
    /**设备ip*/
    @Excel(name = "设备ip", width = 15)
    @ApiModelProperty(value = "设备ip")
    private String ip;
    /**区域名称*/
    @Excel(name = "区域名称", width = 15)
    @ApiModelProperty(value = "区域名称")
    private String districtName;
	@Excel(name = "信息类型", width = 15)
    @ApiModelProperty(value = "信息类型 1通知  2异常")
    @Dict(dicCode = "advertising_screen_list_type")
    private String type;
	/**信息标题*/
	@Excel(name = "信息标题", width = 15)
    @ApiModelProperty(value = "信息标题")
    private String title;
	/**展示开始时间*/
	@Excel(name = "展示开始时间", width = 15, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "展示开始时间")
    private Date startDate;
	/**展示结束时间*/
	@Excel(name = "展示结束时间", width = 15, format = "yyyy-MM-dd HH:mm:ss")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "展示结束时间")
    private Date endDate;
	/**内容*/
	@Excel(name = "内容", width = 15)
    @ApiModelProperty(value = "内容")
    private String content;
	/**创建人Id（sys_user）*/
	@Excel(name = "创建人Id（sys_user）", width = 15)
    @Dict(dictTable = "sys_user", dicText = "realname", dicCode = "id")
    @ApiModelProperty(value = "创建人Id（sys_user）")
    private String createUserId;
	/**修改人Id（sys_user）*/
	@Excel(name = "修改人Id（sys_user）", width = 15)
    @ApiModelProperty(value = "修改人Id（sys_user）")
    private String modifyUserId;
	/**创建时间*/
    @Excel(name = "展示结束时间", width = 15, format = "yyyy-MM-dd HH:mm:ss")
    @JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**修改时间*/
	@Excel(name = "修改时间", width = 15, format = "yyyy-MM-dd")
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;
	/**删除状态*/
	@Excel(name = "删除状态", width = 15)
    @ApiModelProperty(value = "删除状态")
    private Boolean deleted;
}
