package org.jeecg.pm.controller;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import javax.persistence.Id;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.pm.entity.AdvertisingScreenAnnounce;
import org.jeecg.pm.entity.AdvertisingScreenAnnounceVo;
import org.jeecg.pm.entity.AdvertisingScreenSetting;
import org.jeecg.pm.service.IAdvertisingScreenAnnounceService;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.pm.service.IAdvertisingScreenSettingService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 广告屏信息发布
 * @Author: jeecg-boot
 * @Date:   2022-05-18
 * @Version: V1.0
 */
@Api(tags="广告屏信息发布")
@RestController
@RequestMapping("/pm/advertisingScreenAnnounce")
@Slf4j
public class AdvertisingScreenAnnounceController extends JeecgController<AdvertisingScreenAnnounce, IAdvertisingScreenAnnounceService> {
	@Autowired
	private IAdvertisingScreenAnnounceService advertisingScreenAnnounceService;
	@Autowired
	private IAdvertisingScreenSettingService advertisingScreenSettingService;
	
	/**
	 * 分页列表查询
	 *
	 * @param advertisingScreenAnnounce
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "广告屏信息发布-分页列表查询")
	@ApiOperation(value="广告屏信息发布-分页列表查询", notes="广告屏信息发布-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<AdvertisingScreenAnnounceVo>> queryPageList(AdvertisingScreenAnnounce advertisingScreenAnnounce,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		Page<AdvertisingScreenAnnounceVo> page = new Page<AdvertisingScreenAnnounceVo>(pageNo, pageSize);
		IPage<AdvertisingScreenAnnounceVo> pageList = advertisingScreenAnnounceService.pageList(page, advertisingScreenAnnounce);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param advertisingScreenAnnounce
	 * @return
	 */
	@AutoLog(value = "广告屏信息发布-添加")
	@ApiOperation(value="广告屏信息发布-添加", notes="广告屏信息发布-添加")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody AdvertisingScreenAnnounce advertisingScreenAnnounce) {
		LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();
		advertisingScreenAnnounce.setCreateUserId(sysUser.getId());
		advertisingScreenAnnounce.setDeleted(false);
		advertisingScreenAnnounceService.save(advertisingScreenAnnounce);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param advertisingScreenAnnounce
	 * @return
	 */
	@AutoLog(value = "广告屏信息发布-编辑")
	@ApiOperation(value="广告屏信息发布-编辑", notes="广告屏信息发布-编辑")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody AdvertisingScreenAnnounce advertisingScreenAnnounce) {
		advertisingScreenAnnounceService.updateById(advertisingScreenAnnounce);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "广告屏信息发布-通过id删除")
	@ApiOperation(value="广告屏信息发布-通过id删除", notes="广告屏信息发布-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		advertisingScreenAnnounceService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "广告屏信息发布-批量删除")
	@ApiOperation(value="广告屏信息发布-批量删除", notes="广告屏信息发布-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.advertisingScreenAnnounceService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "广告屏信息发布-通过id查询")
	@ApiOperation(value="广告屏信息发布-通过id查询", notes="广告屏信息发布-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<AdvertisingScreenAnnounce> queryById(@RequestParam(name="id",required=true) String id) {
		AdvertisingScreenAnnounce advertisingScreenAnnounce = advertisingScreenAnnounceService.getById(id);
		if(advertisingScreenAnnounce==null) {
			return Result.error("未找到对应数据",null);
		}
		return Result.OK(advertisingScreenAnnounce);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param advertisingScreenAnnounce
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, AdvertisingScreenAnnounce advertisingScreenAnnounce) {
        return super.exportXls(request, advertisingScreenAnnounce, AdvertisingScreenAnnounce.class, "广告屏信息发布");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, AdvertisingScreenAnnounce.class);
    }


	 /**
	  * 设置列表
	  *
	  * @return
	  */
	 @ApiOperation(value="广告屏设置设备名称列表", notes="广告屏设置设备名称列表")
	 @GetMapping(value = "/routesList")
	 public Result<List<AdvertisingScreenSetting>> routesList() {
		 List<AdvertisingScreenSetting> list = advertisingScreenSettingService.list(new QueryWrapper<AdvertisingScreenSetting>().lambda()
				 .eq(AdvertisingScreenSetting::getDeleted, 0)
		 );
		 return Result.OK(list);
	 }

}
