package org.jeecg.pm.hikvision.sdk.response;

import org.jeecg.pm.hikvision.sdk.result.HikvisionBaseResult;

import java.util.List;

/**
 * @author: JJww
 * @Date:2022/3/21
 */
public abstract class HikvisionAbstractResponse<R extends HikvisionBaseResult> implements HikvisionResponse<R> {

    /**
     * 返回的结果对象
     */
    private final Class<R> resultClazz;

    public Boolean isSuccess;
    /**
     * 返回结果是否为多个（数组）
     * 默认false，通过构造参数修改
     */
    private boolean multiple = false;

    /**
     * 异常代码
     * 目前仅请求失败有值
     */
    private String code;

    /**
     * 返回消息，成功为success
     */
    private String msg;

    /**
     * 获取返回对象
     */
    private R result;

    /**
     * 获取返回结果数组
     */
    private List<R> listResult;

    /**
     * 获取网宿错误的返回信息
     */
    private HikvisionBaseResult errorResult;

    public HikvisionAbstractResponse(Class<R> resultClazz) {
        this.resultClazz = resultClazz;
    }

    public HikvisionAbstractResponse(Class<R> resultClazz, boolean multiple) {
        this.resultClazz = resultClazz;
        this.multiple = multiple;
    }

    @Override
    public Class<R> getResultClazz() {
        return resultClazz;
    }

    @Override
    public String getCode() {
        return code;
    }

    @Override
    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getMsg() {
        return this.msg;
    }

    @Override
    public void setMsg(String msg) {
        this.msg = msg;
    }

    @Override
    public R getResult() {
        return result;
    }

    @Override
    public void setResult(R result) {
        this.result = result;
    }

    @Override
    public List<R> getListResult() {
        return this.listResult;
    }

    @Override
    public void setListResult(List<R> listResult) {
        this.listResult = listResult;
    }

    @Override
    public boolean isSuccess() {
        return false;
    }

    @Override
    public void setSuccess(boolean success) {
        this.isSuccess = success;
    }

    @Override
    public boolean isMultiple() {
        return multiple;
    }
}
