package org.jeecg.pm.hikvision.sdk.result.vss.res;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.pm.hikvision.sdk.json.deserialize.ListJoinWithCommaDeserialize;
import org.jeecg.pm.hikvision.sdk.result.HikvisionBaseResult;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/23
 */
@Slf4j
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class HikvisionGetEncodersResult extends HikvisionBaseResult {

    /**
     * 返回数据
     */
    private ResultData data;


    @Slf4j
    @Data
    @EqualsAndHashCode(callSuper = false)
    @Accessors(chain = true)
    public static class ResultData implements Serializable {

        /**
         * 查询数据记录总数
         */
        private Integer total;

        /**
         * 当前页码
         */
        private Integer pageNo;

        /**
         * 每页记录总数
         */
        private Integer pageSize;

        /**
         * 对象列表
         */
        private List<Encoder> list;

    }

    @Slf4j
    @Data
    @EqualsAndHashCode(callSuper = false)
    @Accessors(chain = true)
    public static class Encoder implements Serializable {
        /**
         * 编码设备 UUID
         */
        private String encoderUuid;

        /**
         * 编码设备名称
         */
        private String encoderName;

        /**
         * 编码设备类型码
         * @see org.jeecg.pm.hikvision.sdk.entity.body.vss.res.Constant#ENCODER_MODEL_LIST
         */
        private Integer encoderModel;

        /**
         * 设备用户名
         */
        private String encoderUserName;

        /**
         * 设备端口
         */
        private Integer encoderPort;

        /**
         * 设备 IP
         */
        private String encoderIp;

        /**
         * 专业智能类型码
         * @see org.jeecg.pm.hikvision.sdk.entity.body.vss.res.Constant#SMART_TYPE_LIST
         */
        private String smartType;

        /**
         * 是否支持智能
         * @see org.jeecg.pm.hikvision.sdk.entity.body.vss.res.Constant#SMART_SUPPORT_LIST
         */
        private Integer smartSupport;

        /**
         * 海康设备类型码
         */
        private Integer devType;

        /**
         * 排序字段
         */
        private Integer orderNum;

        /**
         * 中心 UUID
         */
        private String unitUuid;

        /**
         * 更新时间
         */
        private Date updateTime;

        /**
         * 报警输入数
         */
        private Integer alarmIn;

        /**
         * 报警输出数
         */
        private Integer alarmOut;

        /**
         * 可视对讲通道数
         */
        private Integer visIntercomChanNum;

        /**
         * 资源权限集
         */
        @JsonDeserialize(using = ListJoinWithCommaDeserialize.class)
        private List<String> resAuths;
    }
}

/*
报警输入数 Integer 是
报警输出数 Integer 是
可视对讲通道数 Integer 是
resAuths 资源权限集 String 是 编码设备资源权限说明

 */
