package org.jeecg.modules.demo.pm.controller;

import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.demo.pm.entity.PmBuildingInfo;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/17
 */
@Api(tags = "pm_access_control_device")
@RestController
@RequestMapping("/pm/pmBuildingInfo")
@Slf4j
public class PmBuildingInfoController {

    private static final List<PmBuildingInfo> BUILDING_INFOS = Arrays.asList(
            new PmBuildingInfo()
                    .setName("望海路1号楼")
                    .setFloorList(Arrays.asList("-2F", "-1F", "1F", "2F", "3F")),
            new PmBuildingInfo()
                    .setName("望海路2号楼")
                    .setFloorList(Arrays.asList("-3F", "-2F", "-1F", "1F", "2F", "3F", "4F"))
    );

    @GetMapping("/list")
    public Result<List<PmBuildingInfo>> list() {
        return Result.OK(BUILDING_INFOS);
    }
}
