package org.jeecg.pm.hikvision.sdk.entity.body.vss.res;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.pm.hikvision.sdk.entity.body.HikvisionPageModel;
import org.jeecg.pm.hikvision.sdk.json.serialize.ListJoinWithCommaSerialize;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/23
 */
@Slf4j
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionGetEncoders extends HikvisionPageModel {

    public HikvisionGetEncoders() {
    }

    public HikvisionGetEncoders(Integer pageNo, Integer pageSize) {
        super(pageNo, pageSize);
    }

    /**
     * 组织中心UUID集
     */
    @JsonSerialize(using = ListJoinWithCommaSerialize.class)
    private List<String> unitUuids;

    /**
     * 编码设备UUID集
     */
    @JsonSerialize(using = ListJoinWithCommaSerialize.class)
    private List<String> encoderUuids;

    /**
     * 编码设备名称
     */
    private String encoderName;

    /**
     * 编码设备类型码集
     * @see Constant#ENCODER_MODEL_LIST
     */
    @JsonSerialize(using = ListJoinWithCommaSerialize.class)
    private List<String> encoderModel;

    /**
     * 专业智能类型码
     * @see Constant#SMART_TYPE_LIST
     */
    private String smartType;

    public HikvisionGetEncoders setEncoderModel(List<String> encoderModel) {
        if (!Constant.ENCODER_MODEL_LIST.containsAll(encoderModel)) {
            throw new JeecgBootException("不支持的设备类型，支持类型列表：" + Constant.ENCODER_MODEL_LIST);
        }
        this.encoderModel = encoderModel;
        return this;
    }

    public HikvisionGetEncoders setSmartType(String smartType) {
        if (!Constant.SMART_TYPE_LIST.contains(smartType)) {
            throw new JeecgBootException("不支持的专业智能类型码，支持类码列表：" + Constant.SMART_TYPE_LIST);
        }
        this.smartType = smartType;
        return this;
    }
}
