package org.jeecg.pm.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.pm.entity.PmAccessControlDeviceRecord;
import org.jeecg.pm.entity.PmAccessControlDeviceRecordDto;
import org.jeecg.pm.entity.PmAccessControlDeviceRecordVo;
import org.jeecg.pm.service.IPmAccessControlDeviceRecordService;
import org.jeecgframework.poi.excel.def.NormalExcelConstants;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Description: 一卡通出入记录
 * @Author: jeecg-boot
 * @Date: 2022-03-15
 * @Version: V1.0
 */
@Api(tags = "pm_access_control_device_record")
@RestController
@RequestMapping("/pm/pmAccessControlDeviceRecord")
@Slf4j
public class PmAccessControlDeviceRecordController extends JeecgController<PmAccessControlDeviceRecord, IPmAccessControlDeviceRecordService> {
    @Autowired
    private IPmAccessControlDeviceRecordService pmAccessControlDeviceRecordService;

    /**
     * 分页列表查询
     *
     * @param pmAccessControlDeviceRecordDto
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    //@AutoLog(value = "pm_access_control_device_record-分页列表查询")
    @ApiOperation(value = "pm_access_control_device_record-分页列表查询", notes = "pm_access_control_device_record-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<PmAccessControlDeviceRecordVo>> queryPageList(PmAccessControlDeviceRecordDto pmAccessControlDeviceRecordDto,
                                                                    @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                                    @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                                    HttpServletRequest req) {
        Page<PmAccessControlDeviceRecordVo> page = new Page<PmAccessControlDeviceRecordVo>(pageNo, pageSize);
        IPage<PmAccessControlDeviceRecordVo> pageList = pmAccessControlDeviceRecordService.recordPage(page, pmAccessControlDeviceRecordDto);
        return Result.OK(pageList);
    }

    /**
     * 添加
     *
     * @param pmAccessControlDeviceRecord
     * @return
     */
    @AutoLog(value = "pm_access_control_device_record-添加")
    @ApiOperation(value = "pm_access_control_device_record-添加", notes = "pm_access_control_device_record-添加")
    @PostMapping(value = "/add")
    public Result<String> add(@RequestBody PmAccessControlDeviceRecord pmAccessControlDeviceRecord) {
        pmAccessControlDeviceRecordService.save(pmAccessControlDeviceRecord);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param pmAccessControlDeviceRecord
     * @return
     */
    @AutoLog(value = "pm_access_control_device_record-编辑")
    @ApiOperation(value = "pm_access_control_device_record-编辑", notes = "pm_access_control_device_record-编辑")
    @RequestMapping(value = "/edit", method = {RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody PmAccessControlDeviceRecord pmAccessControlDeviceRecord) {
        pmAccessControlDeviceRecordService.updateById(pmAccessControlDeviceRecord);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "pm_access_control_device_record-通过id删除")
    @ApiOperation(value = "pm_access_control_device_record-通过id删除", notes = "pm_access_control_device_record-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name = "id", required = true) String id) {
        pmAccessControlDeviceRecordService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "pm_access_control_device_record-批量删除")
    @ApiOperation(value = "pm_access_control_device_record-批量删除", notes = "pm_access_control_device_record-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.pmAccessControlDeviceRecordService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    //@AutoLog(value = "pm_access_control_device_record-通过id查询")
    @ApiOperation(value = "pm_access_control_device_record-通过id查询", notes = "pm_access_control_device_record-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<PmAccessControlDeviceRecord> queryById(@RequestParam(name = "id", required = true) String id) {
        PmAccessControlDeviceRecord pmAccessControlDeviceRecord = pmAccessControlDeviceRecordService.getById(id);
        if (pmAccessControlDeviceRecord == null) {
            return Result.error("未找到对应数据", null);
        }
        return Result.OK(pmAccessControlDeviceRecord);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param pmAccessControlDeviceRecordDto
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request,
                                  @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                  @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                  PmAccessControlDeviceRecordDto pmAccessControlDeviceRecordDto,
                                  HttpServletRequest req) {
        // Step.1 组装查询条件
        LoginUser sysUser = (LoginUser) SecurityUtils.getSubject().getPrincipal();

        // Step.2 获取导出数据
        Page<PmAccessControlDeviceRecordVo> page = new Page<>(pageNo, pageSize);
        IPage<PmAccessControlDeviceRecordVo> pmAccessControlDeviceRecordVoIPage = pmAccessControlDeviceRecordService.recordPage(page, pmAccessControlDeviceRecordDto);
        List<PmAccessControlDeviceRecordVo> pageList = pmAccessControlDeviceRecordVoIPage.getRecords();
        List<PmAccessControlDeviceRecordVo> exportList = null;

        // 过滤选中数据
        String selections = request.getParameter("selections");
        if (oConvertUtils.isNotEmpty(selections)) {
            List<String> selectionList = Arrays.asList(selections.split(","));
            exportList = pageList.stream().filter(item -> selectionList.contains(item.getId())).collect(Collectors.toList());
        } else {
            exportList = pageList;
        }

        // Step.3 AutoPoi 导出Excel
        ModelAndView mv = new ModelAndView(new JeecgEntityExcelView());
        mv.addObject(NormalExcelConstants.FILE_NAME, "一卡通打卡记录");
        mv.addObject(NormalExcelConstants.CLASS, PmAccessControlDeviceRecordVo.class);
        ExportParams exportParams=new ExportParams("一卡通打卡记录" + "详情报表", "导出人:" + sysUser.getRealname(), "一卡通打卡记录管理");
        mv.addObject(NormalExcelConstants.PARAMS,exportParams);
        mv.addObject(NormalExcelConstants.DATA_LIST, exportList);
        return mv;
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, PmAccessControlDeviceRecord.class);
    }

}
