package org.jeecg.pm.entity;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.jeecg.common.aspect.annotation.Dict;
import org.jeecgframework.poi.excel.annotation.Excel;

import java.io.Serializable;

/**
 * @Description: 请求参数
 * @Author: jeecg-boot
 * @Date: 2022-03-15
 * @Version: V1.0
 */
@Data
public class PmAccessControlDeviceRecordDto implements Serializable {
    /**
     * 设备类型
     */
    @ApiModelProperty(value = "设备类型 1:出入口闸机 2:访客一体机 3:自助访客机 4:身份证读卡器 5:人脸识别")
    @Excel(name = "设备类型", width = 15,dicCode = "alarm_query_equipmentType")
    @Dict(dicCode = "alarm_query_equipmentType")
    private Integer type;
    /**
     * 设备名称
     */
    @Excel(name = "设备名称", width = 15)
    @ApiModelProperty(value = "设备名称")
    private String name;

}
