package org.jeecg.pm.hikvision.sdk.result.vss.playback;

import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.pm.hikvision.sdk.entity.Constant;
import org.jeecg.pm.hikvision.sdk.result.HikvisionBaseResult;
import org.jeecg.pm.hikvision.sdk.result.HikvisionPageResultData;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/24
 */
@Slf4j
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionGetRecordPlansByCameraUuidsResult extends HikvisionBaseResult {

    private HikvisionPageResultData<RecordPlan> data;

    @Slf4j
    @Data
    @EqualsAndHashCode(callSuper = false)
    @Accessors(chain = true)

    public static class RecordPlan {

        /**
         * 录像计划 UUID
         */
        private String recordPlanUuid;

        /**
         * 是否启用录像计划
         */
        @JsonFormat(shape = JsonFormat.Shape.NUMBER)
        private Boolean enabled;

        /**
         * 录像计划名称
         */
        private String planName;

        /**
         * 录像计划类型
         * @see Constant#PLAN_TYPE_LIST
         */
        private Integer planType;

        /**
         * 监控点 UUID
         */
        private String cameraUuid;

        /**
         * 编码设备 UUID
         */
        private String encoderUuid;

    }
}
