package org.jeecg.pm.hikvision.sdk.entity.body;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

/**
 * @author: JJww
 * @Date:2022/3/21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public abstract class HikvisionBodyModel implements Serializable {

    /**
     * appKey
     */
    @JsonProperty("appkey")
    private String appKey;

    /**
     * 毫秒时间戳
     */
    private Long time = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);

    /**
     * 操作用户 UUID 自动填充
     */
    private String opUserUuid;

}
