package org.jeecg.pm.hikvision.sdk.request.base.user;

import com.chanjx.utils.HttpMethod;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.http.entity.ContentType;
import org.jeecg.pm.hikvision.sdk.entity.body.HikvisionBodyModel;
import org.jeecg.pm.hikvision.sdk.entity.body.base.user.HikvisionGetDefaultUserUuidQuery;
import org.jeecg.pm.hikvision.sdk.request.HikvisionAbstractRequest;
import org.jeecg.pm.hikvision.sdk.response.base.user.HikvisionGetDefaultUserUuidResponse;
import org.jeecg.pm.hikvision.sdk.result.base.user.HikvisionGetDefaultUserUuidBaseResult;

/**
 * @author: JJww
 * @Date:2022/3/21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionGetDefaultUserUuidRequest extends HikvisionAbstractRequest<HikvisionGetDefaultUserUuidResponse, HikvisionGetDefaultUserUuidBaseResult> {

    private final HikvisionGetDefaultUserUuidQuery hikvisionGetDefaultUserUuidQuery = new HikvisionGetDefaultUserUuidQuery();

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Class<HikvisionGetDefaultUserUuidResponse> getResponseClazz() {
        return HikvisionGetDefaultUserUuidResponse.class;
    }

    @Override
    public Class<HikvisionGetDefaultUserUuidBaseResult> getResultClazz() {
        return HikvisionGetDefaultUserUuidBaseResult.class;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getReqPath() {
        return "/openapi/service/base/user/getDefaultUserUuid";
    }

    @Override
    public HikvisionBodyModel getModel() {
        return hikvisionGetDefaultUserUuidQuery;
    }
}
