package org.jeecg.pm.entity;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.math.BigDecimal;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.springframework.format.annotation.DateTimeFormat;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecg.common.aspect.annotation.Dict;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * @Description: pm_monitoring_device
 * @Author: jeecg-boot
 * @Date:   2022-05-25
 * @Version: V1.0
 */
@Data
@TableName("pm_monitoring_device")
@Accessors(chain = true)
@EqualsAndHashCode(callSuper = false)
@ApiModel(value="pm_monitoring_device对象", description="pm_monitoring_device")
public class PmMonitoringDevice implements Serializable {
    private static final long serialVersionUID = 1L;

	/**id*/
	@TableId(type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id")
    private Long id;
	/**区域名称*/
	@Excel(name = "区域名称", width = 15)
    @ApiModelProperty(value = "区域名称")
    private String districtName;
	/**设备名称*/
	@Excel(name = "设备名称", width = 15)
    @ApiModelProperty(value = "设备名称")
    private String name;
	/**设备编码*/
	@Excel(name = "设备编码", width = 15)
    @ApiModelProperty(value = "设备编码")
    private String code;
	/**设备类型*/
	@Excel(name = "设备类型", width = 15,dicCode = "monitoring_type")
    @ApiModelProperty(value = "设备类型")
    @Dict(dicCode = "monitoring_type")
    private String type;
	/**设备ip*/
	@Excel(name = "设备ip", width = 15)
    @ApiModelProperty(value = "设备ip")
    private String ip;
	/**所属设备*/
	@Excel(name = "所属设备", width = 15)
    @ApiModelProperty(value = "所属设备")
    private String theirEquipment;
	/**xy值*/
	@Excel(name = "xy值", width = 15)
    @ApiModelProperty(value = "xy值")
    private String coordinate;
	/**状态 1:正常 2:离线 3:维修*/
	@Excel(name = "状态", width = 15,dicCode = "access_control_status")
    @ApiModelProperty(value = "状态 1:正常 2:离线 3:维修")
    @Dict(dicCode = "access_control_status")
    private String status;
	/**端口*/
	@Excel(name = "端口", width = 15)
    @ApiModelProperty(value = "端口")
    private String port;
	/**通道号*/
	@Excel(name = "通道号", width = 15)
    @ApiModelProperty(value = "通道号")
    private String chanelNum;
	/**创建人Id（sys_user）*/
	@Excel(name = "创建人", width = 15,dictTable = "sys_user", dicText = "realname", dicCode = "id")
    @ApiModelProperty(value = "创建人Id（sys_user）")
    @Dict(dictTable = "sys_user", dicText = "realname", dicCode = "id")
    private String createUserId;
	/**修改人Id（sys_user）*/
    @ApiModelProperty(value = "修改人Id（sys_user）")
    private String modifyUserId;
	/**创建时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "创建时间")
    private Date createTime;
	/**修改时间*/
	@JsonFormat(timezone = "GMT+8",pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern="yyyy-MM-dd")
    @ApiModelProperty(value = "修改时间")
    private Date modifyTime;
	/**删除状态*/
    @ApiModelProperty(value = "删除状态")
    private Boolean deleted;
}
