package org.jeecg.pm.controller;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.query.QueryGenerator;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import lombok.extern.slf4j.Slf4j;

import org.jeecg.pm.entity.ParkingManagement;
import org.jeecg.pm.service.IParkingManagementService;
import org.jeecg.common.system.base.controller.JeecgController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.jeecg.common.aspect.annotation.AutoLog;

 /**
 * @Description: 车位管理
 * @Author: jeecg-boot
 * @Date:   2022-04-25
 * @Version: V1.0
 */
@Api(tags="车位管理")
@RestController
@RequestMapping("/pm/parkingManagement")
@Slf4j
public class ParkingManagementController extends JeecgController<ParkingManagement, IParkingManagementService> {
	@Autowired
	private IParkingManagementService parkingManagementService;
	
	/**
	 * 分页列表查询
	 *
	 * @param parkingManagement
	 * @param pageNo
	 * @param pageSize
	 * @param req
	 * @return
	 */
	//@AutoLog(value = "车位管理-分页列表查询")
	@ApiOperation(value="车位管理-分页列表查询", notes="车位管理-分页列表查询")
	@GetMapping(value = "/list")
	public Result<IPage<ParkingManagement>> queryPageList(ParkingManagement parkingManagement,
								   @RequestParam(name="pageNo", defaultValue="1") Integer pageNo,
								   @RequestParam(name="pageSize", defaultValue="10") Integer pageSize,
								   HttpServletRequest req) {
		QueryWrapper<ParkingManagement> queryWrapper = QueryGenerator.initQueryWrapper(parkingManagement, req.getParameterMap());
		Page<ParkingManagement> page = new Page<ParkingManagement>(pageNo, pageSize);
		IPage<ParkingManagement> pageList = parkingManagementService.page(page, queryWrapper);
		return Result.OK(pageList);
	}
	
	/**
	 *   添加
	 *
	 * @param parkingManagement
	 * @return
	 */
	@AutoLog(value = "车位管理-添加")
	@ApiOperation(value="车位管理-添加", notes="车位管理-添加")
	@PostMapping(value = "/add")
	public Result<String> add(@RequestBody ParkingManagement parkingManagement) {
		parkingManagementService.save(parkingManagement);
		return Result.OK("添加成功！");
	}
	
	/**
	 *  编辑
	 *
	 * @param parkingManagement
	 * @return
	 */
	@AutoLog(value = "车位管理-编辑")
	@ApiOperation(value="车位管理-编辑", notes="车位管理-编辑")
	@RequestMapping(value = "/edit", method = {RequestMethod.PUT,RequestMethod.POST})
	public Result<String> edit(@RequestBody ParkingManagement parkingManagement) {
		parkingManagementService.updateById(parkingManagement);
		return Result.OK("编辑成功!");
	}
	
	/**
	 *   通过id删除
	 *
	 * @param id
	 * @return
	 */
	@AutoLog(value = "车位管理-通过id删除")
	@ApiOperation(value="车位管理-通过id删除", notes="车位管理-通过id删除")
	@DeleteMapping(value = "/delete")
	public Result<String> delete(@RequestParam(name="id",required=true) String id) {
		parkingManagementService.removeById(id);
		return Result.OK("删除成功!");
	}
	
	/**
	 *  批量删除
	 *
	 * @param ids
	 * @return
	 */
	@AutoLog(value = "车位管理-批量删除")
	@ApiOperation(value="车位管理-批量删除", notes="车位管理-批量删除")
	@DeleteMapping(value = "/deleteBatch")
	public Result<String> deleteBatch(@RequestParam(name="ids",required=true) String ids) {
		this.parkingManagementService.removeByIds(Arrays.asList(ids.split(",")));
		return Result.OK("批量删除成功!");
	}
	
	/**
	 * 通过id查询
	 *
	 * @param id
	 * @return
	 */
	//@AutoLog(value = "车位管理-通过id查询")
	@ApiOperation(value="车位管理-通过id查询", notes="车位管理-通过id查询")
	@GetMapping(value = "/queryById")
	public Result<ParkingManagement> queryById(@RequestParam(name="id",required=true) String id) {
		ParkingManagement parkingManagement = parkingManagementService.getById(id);
		if(parkingManagement==null) {
			return Result.error("未找到对应数据",null);
		}
		return Result.OK(parkingManagement);
	}

    /**
    * 导出excel
    *
    * @param request
    * @param parkingManagement
    */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, ParkingManagement parkingManagement) {
        return super.exportXls(request, parkingManagement, ParkingManagement.class, "车位管理");
    }

    /**
      * 通过excel导入数据
    *
    * @param request
    * @param response
    * @return
    */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, ParkingManagement.class);
    }

}
