package org.jeecg.pm.hikvision.sdk.entity.body.vss.record;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.pm.hikvision.sdk.entity.body.HikvisionBodyModel;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/25
 */
@Slf4j
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionEndManualRecord extends HikvisionBodyModel {

    public HikvisionEndManualRecord(String cameraUuid, Integer planType) {
        this.cameraUuid = cameraUuid;
        this.planType = planType;
    }

    /**
     * 监控点 UUID
     */
    private String cameraUuid;

    /**
     * 录像计划类型
     *
     * @see org.jeecg.pm.hikvision.sdk.entity.Constant#RECORD_TYPE_LIST
     */
    private Integer planType;
}
