package org.jeecg.pm.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.pm.entity.PmEventInfo;
import org.jeecg.pm.service.IPmEventInfoService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.SimpleDateFormat;
import java.util.Arrays;

/**
 * @Description: pm_event_info
 * @Author: jeecg-boot
 * @Date: 2022-04-01
 * @Version: V1.0
 */
@Api(tags = "pm_event_info")
@RestController
@RequestMapping("/pm/pmEventInfo")
@Slf4j
public class PmEventInfoController extends JeecgController<PmEventInfo, IPmEventInfoService> {
    @Autowired
    private IPmEventInfoService pmEventInfoService;

    /**
     * 分页列表查询
     *
     * @param pmEventInfo
     * @param pageNo
     * @param pageSize
     * @param req
     * @return
     */
    //@AutoLog(value = "pm_event_info-分页列表查询")
    @ApiOperation(value = "pm_event_info-分页列表查询", notes = "pm_event_info-分页列表查询")
    @GetMapping(value = "/list")
    public Result<IPage<PmEventInfo>> queryPageList(PmEventInfo pmEventInfo,
                                                    @RequestParam(name = "pageNo", defaultValue = "1") Integer pageNo,
                                                    @RequestParam(name = "pageSize", defaultValue = "10") Integer pageSize,
                                                    HttpServletRequest req) {

        final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        final LambdaQueryWrapper<PmEventInfo> pmEventInfoLambdaQueryWrapper = new QueryWrapper<PmEventInfo>()
                .lambda()
                .eq(pmEventInfo.getSubsystem() != null, PmEventInfo::getSubsystem, pmEventInfo.getSubsystem())
                .orderByDesc(PmEventInfo::getCreateTime);
        if (pmEventInfo.getCreateTime() != null) { //.apply condition无效, 先这样写
            pmEventInfoLambdaQueryWrapper.apply("UNIX_TIMESTAMP(create_time) >= UNIX_TIMESTAMP('" + sdf.format(pmEventInfo.getCreateTime()) + "')");
        }
        if (pmEventInfo.getStopTime() != null) {
            pmEventInfoLambdaQueryWrapper.apply("UNIX_TIMESTAMP(stop_time) <= UNIX_TIMESTAMP('" + sdf.format(pmEventInfo.getStopTime()) + "')");
        }
        return Result.OK(pmEventInfoService.page(new Page<PmEventInfo>(pageNo, pageSize), pmEventInfoLambdaQueryWrapper));

    }

    /**
     * 添加
     *
     * @param pmEventInfo
     * @return
     */
    @AutoLog(value = "pm_event_info-添加")
    @ApiOperation(value = "pm_event_info-添加", notes = "pm_event_info-添加")
    @PostMapping(value = "/add")
    public Result<String> add(@RequestBody PmEventInfo pmEventInfo) {
        pmEventInfo.setId(IdWorker.getId());
        pmEventInfoService.save(pmEventInfo);
        return Result.OK("添加成功！");
    }

    /**
     * 编辑
     *
     * @param pmEventInfo
     * @return
     */
    @AutoLog(value = "pm_event_info-编辑")
    @ApiOperation(value = "pm_event_info-编辑", notes = "pm_event_info-编辑")
    @RequestMapping(value = "/edit", method = {RequestMethod.PUT, RequestMethod.POST})
    public Result<String> edit(@RequestBody PmEventInfo pmEventInfo) {
        pmEventInfoService.updateById(pmEventInfo);
        return Result.OK("编辑成功!");
    }

    /**
     * 通过id删除
     *
     * @param id
     * @return
     */
    @AutoLog(value = "pm_event_info-通过id删除")
    @ApiOperation(value = "pm_event_info-通过id删除", notes = "pm_event_info-通过id删除")
    @DeleteMapping(value = "/delete")
    public Result<String> delete(@RequestParam(name = "id", required = true) String id) {
        pmEventInfoService.removeById(id);
        return Result.OK("删除成功!");
    }

    /**
     * 批量删除
     *
     * @param ids
     * @return
     */
    @AutoLog(value = "pm_event_info-批量删除")
    @ApiOperation(value = "pm_event_info-批量删除", notes = "pm_event_info-批量删除")
    @DeleteMapping(value = "/deleteBatch")
    public Result<String> deleteBatch(@RequestParam(name = "ids", required = true) String ids) {
        this.pmEventInfoService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK("批量删除成功!");
    }

    /**
     * 通过id查询
     *
     * @param id
     * @return
     */
    //@AutoLog(value = "pm_event_info-通过id查询")
    @ApiOperation(value = "pm_event_info-通过id查询", notes = "pm_event_info-通过id查询")
    @GetMapping(value = "/queryById")
    public Result<PmEventInfo> queryById(@RequestParam(name = "id", required = true) String id) {
        PmEventInfo pmEventInfo = pmEventInfoService.getById(id);
        if (pmEventInfo == null) {
            return Result.error("未找到对应数据", null);
        }
        return Result.OK(pmEventInfo);
    }

    /**
     * 导出excel
     *
     * @param request
     * @param pmEventInfo
     */
    @RequestMapping(value = "/exportXls")
    public ModelAndView exportXls(HttpServletRequest request, PmEventInfo pmEventInfo) {
        return super.exportXls(request, pmEventInfo, PmEventInfo.class, "pm_event_info");
    }

    /**
     * 通过excel导入数据
     *
     * @param request
     * @param response
     * @return
     */
    @RequestMapping(value = "/importExcel", method = RequestMethod.POST)
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, PmEventInfo.class);
    }

}
