package org.jeecg.pm.hikvision.sdk.entity.query;

import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;

/**
 * @author: JJww
 * @Date:2022/3/21
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public abstract class HikvisionQueryModel implements Serializable {

    /**
     * appKey
     */
    @JsonAlias("appkey")
    private String appKey;

    /**
     * 毫秒时间戳
     */
    private Long time = LocalDateTime.now().toEpochSecond(ZoneOffset.UTC);

    /**
     * 认证参数
     */
    private String token;

}
