package org.jeecg.modules.demo.pm.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import org.jeecg.modules.demo.pm.entity.PmAccessControlDevice;
import org.jeecg.modules.demo.pm.mapper.PmAccessControlDeviceMapper;
import org.jeecg.modules.demo.pm.service.IPmAccessControlDeviceService;
import org.springframework.stereotype.Service;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description: pm_access_control_device
 * @Author: jeecg-boot
 * @Date: 2022-03-15
 * @Version: V1.0
 */
@Service
public class PmAccessControlDeviceServiceImpl extends ServiceImpl<PmAccessControlDeviceMapper, PmAccessControlDevice> implements IPmAccessControlDeviceService {
    @Override
    public boolean save(PmAccessControlDevice entity) {
        entity.setId(IdWorker.getId())
                .setCreateTime(new Date())
                .setModifyTime(new Date());
        return super.save(entity);
    }

    @Override
    public boolean updateById(PmAccessControlDevice entity) {
        entity.setModifyTime(new Date());
        return super.updateById(entity);
    }

    @Override
    public boolean removeById(Serializable id) {
        return update(
                new UpdateWrapper<PmAccessControlDevice>()
                        .lambda()
                        .eq(PmAccessControlDevice::getId, id)
                        .set(PmAccessControlDevice::getDeleted, true)
                        .set(PmAccessControlDevice::getModifyTime, new Date()));
    }
}
