package org.jeecg.pm.hikvision.sdk.request.vss.preview;

import com.chanjx.utils.HttpMethod;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.http.entity.ContentType;
import org.jeecg.pm.hikvision.sdk.entity.body.HikvisionBodyModel;
import org.jeecg.pm.hikvision.sdk.entity.body.vss.preview.HikvisiongetPreviewParamByCameraUuid;
import org.jeecg.pm.hikvision.sdk.request.HikvisionAbstractRequest;
import org.jeecg.pm.hikvision.sdk.response.vss.preview.HikvisionPreviewParamByCameraUuidResponse;
import org.jeecg.pm.hikvision.sdk.result.vss.preview.HikvisionPreviewParamByCameraUuidResult;

/**
 * @author: JJww
 * @Date:2022/3/21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionPreviewParamByCameraUuidRequest extends HikvisionAbstractRequest<HikvisionPreviewParamByCameraUuidResponse, HikvisionPreviewParamByCameraUuidResult> {

    private HikvisiongetPreviewParamByCameraUuid hikvisiongetPreviewParamByCameraUuid;

    public HikvisionPreviewParamByCameraUuidRequest(HikvisiongetPreviewParamByCameraUuid hikvisiongetPreviewParamByCameraUuid) {
        this.hikvisiongetPreviewParamByCameraUuid = hikvisiongetPreviewParamByCameraUuid;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Class<HikvisionPreviewParamByCameraUuidResponse> getResponseClazz() {
        return HikvisionPreviewParamByCameraUuidResponse.class;
    }

    @Override
    public Class<HikvisionPreviewParamByCameraUuidResult> getResultClazz() {
        return HikvisionPreviewParamByCameraUuidResult.class;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getReqPath() {
        return "/openapi/service/vss/preview/getPreviewParamByCameraUuid";
    }

    @Override
    public HikvisionBodyModel getModel() {
        return hikvisiongetPreviewParamByCameraUuid;
    }

    @Override
    public void setModel(HikvisionBodyModel model) {
        this.hikvisiongetPreviewParamByCameraUuid = (HikvisiongetPreviewParamByCameraUuid) model;
    }
}
