package org.jeecg.pm.hikvision.sdk.request.base.res;

import com.chanjx.utils.HttpMethod;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.http.entity.ContentType;
import org.jeecg.pm.hikvision.sdk.entity.body.HikvisionBodyModel;
import org.jeecg.pm.hikvision.sdk.entity.body.base.res.HikvisionGetPlatSubsytem;
import org.jeecg.pm.hikvision.sdk.request.HikvisionAbstractRequest;
import org.jeecg.pm.hikvision.sdk.response.base.res.HikvisionGetPlatSubsytemResponse;
import org.jeecg.pm.hikvision.sdk.result.base.res.HikvisionGetPlatSubsytemResult;

/**
 * @author: JJww
 * @Date:2022/3/24
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionGetPlatSubsytemRequest extends HikvisionAbstractRequest<HikvisionGetPlatSubsytemResponse, HikvisionGetPlatSubsytemResult> {

    private HikvisionGetPlatSubsytem hikvisionGetPlatSubsytem;

    public HikvisionGetPlatSubsytemRequest(HikvisionGetPlatSubsytem hikvisionGetPlatSubsytem) {
        this.hikvisionGetPlatSubsytem = hikvisionGetPlatSubsytem;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Class<HikvisionGetPlatSubsytemResponse> getResponseClazz() {
        return HikvisionGetPlatSubsytemResponse.class;
    }

    @Override
    public Class<HikvisionGetPlatSubsytemResult> getResultClazz() {
        return HikvisionGetPlatSubsytemResult.class;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getReqPath() {
        return "/openapi/service/base/res/getPlatSubsytem";
    }

    @Override
    public HikvisionBodyModel getModel() {
        return hikvisionGetPlatSubsytem;
    }

    @Override
    public void setModel(HikvisionBodyModel model) {
        this.hikvisionGetPlatSubsytem = (HikvisionGetPlatSubsytem) model;
    }
}
