package org.jeecg.pm.hikvision.sdk.parser;

import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.pm.hikvision.sdk.result.HikvisionBaseResult;

import java.util.List;

/**
 * <p>
 *
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/22
 */
public interface HikvisionParser<R extends HikvisionBaseResult> {
    /**
     * 把响应字符串解释成相应的领域对象。
     *
     * @param resp 响应字符串
     * @return 领域对象
     */
    R parse(String resp) throws JeecgBootException;

    /**
     *
     * @param resp
     * @return
     * @throws JeecgBootException
     */
    List<R> parseList(String resp) throws JeecgBootException;

    /**
     * 获取响应类类型。
     */
    Class<R> getResultClazz() throws JeecgBootException;

    R parseErrorResult(String resp) throws JeecgBootException;

}
