package org.jeecg.pm.hikvision.sdk.request.vss.res;

import com.chanjx.utils.HttpMethod;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import org.apache.http.entity.ContentType;
import org.jeecg.pm.hikvision.sdk.entity.body.HikvisionBodyModel;
import org.jeecg.pm.hikvision.sdk.entity.body.vss.res.HikvisionGetEncoders;
import org.jeecg.pm.hikvision.sdk.request.HikvisionAbstractRequest;
import org.jeecg.pm.hikvision.sdk.response.vss.res.HikvisionGetEncodersResponse;
import org.jeecg.pm.hikvision.sdk.result.vss.res.HikvisionGetEncodersResult;

/**
 * @author: JJww
 * @Date:2022/3/21
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
public class HikvisionGetEncodersRequest extends HikvisionAbstractRequest<HikvisionGetEncodersResponse, HikvisionGetEncodersResult> {

    private HikvisionGetEncoders hikvisionGetEncoders;

    public HikvisionGetEncodersRequest(HikvisionGetEncoders hikvisionGetEncoders) {
        this.hikvisionGetEncoders = hikvisionGetEncoders;
    }

    @Override
    public ContentType getContentType() {
        return ContentType.APPLICATION_JSON;
    }

    @Override
    public Class<HikvisionGetEncodersResponse> getResponseClazz() {
        return HikvisionGetEncodersResponse.class;
    }

    @Override
    public Class<HikvisionGetEncodersResult> getResultClazz() {
        return HikvisionGetEncodersResult.class;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getReqPath() {
        return "/openapi/service/vss/res/getEncoders";
    }

    @Override
    public HikvisionBodyModel getModel() {
        return hikvisionGetEncoders;
    }

    @Override
    public void setModel(HikvisionBodyModel model) {
        this.hikvisionGetEncoders = (HikvisionGetEncoders) model;
    }
}
