package org.jeecg.pm.hikvision.sdk.json.deserialize;

import com.chanjx.utils.StringUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.TextNode;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;

/**
 * <p>
 * Jackson自定义序列化：将迭代器序列化成以逗号分隔的字符串
 * </p>
 *
 * @author 陈俊雄
 * @since 2022/3/23
 */
public class ListJoinWithCommaDeserialize extends JsonDeserializer<Iterable<Object>> {
    @Override
    public Iterable<Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        final TreeNode treeNode = p.getCodec().readTree(p);
        return new ArrayList<>(Arrays.asList(StringUtils.split(((TextNode) treeNode).asText(), ",")));
    }
}
